---
Note type: Zettel
tags:
  - "#Zettel"
Related areas:
  - "[[Research]]"
Related projects:
  - "[[Paper X]]"
Related tasks: 
Related MoCs:
  - "[[Performativity MoC]]"
Related references:
  - "[[Fournier & Grey 2000]]"
  - "[[Spicer et al. 2009]]"
  - "[[Alvesson & Spicer 2012]]"
  - "[[King & Learmonth 2015]]"
  - "[[Wickert & Schaefer 2015]]"
  - "[[King 2015]]"
  - "[[Gond et al. 2016]]"
  - "[[Cabantous, Gond, Harding, Learmonth 2016]]"
  - "[[Fleming & Banerjee 2016]]"
  - "[[Spicer, Alvesson & Kärreman 2016]]"
  - "[[Learmonth, Harding, Gond & Cabantous 2016]]"
  - "[[Schaefer & Wickert 2016]]"
  - "[[Parker & Parker 2017]]"
  - "[[King & Land 2018]]"
  - "[[Contu 2018]]"
  - "[[Butler, Delaney & Spoelstra 2018]]"
  - "[[Reedy & King 2019]]"
  - "[[Contu 2020]]"
  - "[[Just, De Cock & Schaefer 2021]]"
  - "[[Kjærgaard et al. 2023]]"
  - "[[Callon 2007]]"
Related zettels:
  - "[[impure politics]]"
  - "[[economic performativity]]"
  - "[[performativity]]"
  - "[[critical performativity]]"
  - "[[Critical Management Studies]]"
  - "[[anti-performativity]]"
  - "[[interstitial social transformation]]"
  - "[[symbiotic social transformation]]"
  - "[[heterotopia]]"
  - "[[utopia]]"
  - "[[impure politics|purity politics]]"
  - "[[tempered radicalism]]"
  - "[[tyranny of hierarchy]]"
  - "[[tyranny of structurelessness]]"
Related meeting notes: 
Related resources: 
Related people:
  - "[[Mats Alvesson]]"
  - "[[André Spicer]]"
  - "[[Dan Kärreman]]"
  - "[[J.L. Austin]]"
  - "[[Judith Butler]]"
aliases:
  - performative CMS
Creation date: 2024-05-27
Last modified: 2024-05-27
---
## Fleeting notes
## General notes

### Conceptual roots and connections

"Marx's ‘Theses on Feuerbach’: ‘philosophers have only interpreted the world in various ways. The point, however, is to change it’ (Eagleton, 2011)." ([[King & Learmonth 2015]])

The term [[performativity]] was originally used by [[Fournier & Grey 2000]] in defining CMS as against management performance (efficiency, efficacy) - [[anti-performativity]]
[[Spicer et al. 2009]] picked this up through the lens of [[Butler 1990]]'s performativity, coining the term [[critical performativity]]
Labelled the [[performative turn]] in [[Critical Management Studies]] ([[King 2015]])

Similar terms:
- performative CMS
- [[progressive performativity]]
- [[activist research]]
- [[intellectual activism]]
- [[academic activism]]
- [[emancipatory research]]
- [[emancipatory social science]]
- [[emancipatory critique]]

#### Introduced as 'performative CMS' by [[Spicer et al. 2009]]

- “we would like to suggest that performativity is not just about efficiency, but it also involves active intervention into discourse and practice.” ([[Spicer et al. 2009]], p. 543)
- Performativity can involve “possibly subversive mobilizations and citations of previous performances” ([[Spicer et al. 2009]], p. 544)
- “If CMS was to think of itself as a performative enterprise, its central aim would be to actively and subversively intervene in managerial discourse and practices.” ([[Spicer et al. 2009]], p. 544)

### Definitions of [[critical performativity]]

[[critical performativity]] is "active and subversive intervention into managerial discourses and practices. This is achieved through affirmation, care, pragmatism, engagement with potentialities, and a normative orientation. {...} Critical performativity also moves beyond the cynicism that pervades CMS. It does so by recognizing that critique must involve an affirmative movement alongside the negative movement that seems to predominate in CMS today." ([[Spicer et al. 2009]] p. 538) - *this aligns with [[Elder-Vass 2022]]'s argument, though he does not frame it in terms of [[performativity]]*

[[critical performativity]] refers to "scholars’ subversive interventions that can involve the production of new subjectivities, the constitution of new organizational models and/or the bridging of these models to current social movements" ([[Esper, Cabantous, Barin-Cruz & Gond 2017]] p. 671)

[[critical performativity]] is “the enactment of subversive practices through the competition of a subversive agencement against other agencements pursuing their own agenda.” [Ouahab and Maclouf, 2019, p. 538](zotero://select/library/items/WHFTGN55) - drawing on [[Michel Callon]], [[Donald MacKenzie]] et al in defining [[agencement]] as “the assemblages or arrangements—which are simultaneously human and nonhuman, social and technical, textual and material—from which action springs” ([[MacKenzie et al. 2007]], p. 14)

[[Leca, Gond & Barin Cruz 2014]] (p. 687-8) distinguish a more discursive vs. a more bodily understanding of performativity
- They align [[Spicer et al. 2009]] with the **more discursive** strand, aligned with Austin's speech acts
- They align [[Butler 1993]] with the **more material**, bodily understanding

Relation to the broader concept of management theory relevance:
- BOTH “a *theoretical lens* for thinking about the relevance of critical management research” ([[Butler, Delaney & Spoelstra 2018]], p. 429)
- AND “a call for critically inclined scholars to *engage* with organizational practitioners beyond academia” ([[Butler, Delaney & Spoelstra 2018]], p. 429)
- [[critical performativity]] is “a CMS-inflected variation on the {broader} relevance theme” in MOS ([[Butler, Delaney & Spoelstra 2018]], p. 430)

### Approaches to [[critical performativity]]

#### [[critical performativity|performative CMS]] / [[critical performativity]]/ [[progressive performativity]]

- **Key texts**: [[Spicer et al. 2009]]; [[Spicer, Alvesson & Kärreman 2016]]; [[Alvesson & Spicer 2012]]; [[Wickert & Schaefer 2015]]; [[Schaefer & Wickert 2016]]; [[Koss Hartmann 2014]]
- [[critical performativity]]
	- Constant [[dialectical movement]] between pragmatic engagement and emancipatory critique” ([[Alvesson & Spicer 2012]], p. 385)
	- Moves from [[Fournier & Grey 2000]]’s Lyotardian conceptualization of performativity as instrumental efficacy to a **speech act-based performativity** drawing from [[J.L. Austin]] and [[Judith Butler]]
	- “an **ethic of affirmation and care** implies that CMS ought to listen to management’s side of the story” ([[Fleming & Banerjee 2016]], p. 5)
	- “CMS must be less ‘utopian’ in its emancipatory ambitions. Incremental and piecemeal change is more doable given the economic pressures managers confront in their daily routines and practices.” ([[Fleming & Banerjee 2016]], p. 6) - i.e. advocates for **[[symbiotic social transformation]]**
- [[progressive performativity]]
	- ‘moving forward by actively working towards incremental, rather than radical transformation of unfavourable social conditions’ ([[Wickert & Schaefer 2015]]: 9–10) -  **[[symbiotic social transformation]]**
- [[subversive engagement]] / [[subversive functionalism]]
	- [[Koss Hartmann 2014]] proposed the concept of “‘subversive engagement’ with the canon of established mainstream theory, which might enable critical researchers to detect transformative potential in established mainstream theory and/or to fertilize mainstream functionalist theory with alternative insights.” [Just et al., 2021, p. 91](zotero://select/library/items/6ARWLBYJ)

#### [[intellectual activism]] / [[academic activism]]

- **Key texts**: [[Contu 2018]] ; [[Reedy & King 2019]]
- [[intellectual activism]]: ‘the myriad ways in which people place the power of their ideas in service to social justice’ (Hill Collins, 2013: ix)
- “critical performativity promotes organizational scholarship as a form of [[academic activism]], seeing engaged research as a route to transformative change (Kieser & Leiner, 2012).” [Reedy and King, 2019, p. 565](zotero://select/library/items/82NUNZET)
	- “Critical performativity proposes an interventionist approach, where critical theory is used to transform organizational practice.” [Reedy and King, 2019, p. 565](zotero://select/library/items/82NUNZET)

#### Affirmative critical engagement with [[Alternative Organizations]]

- **Key texts**: [[King 2015]] ; [[King & Land 2018]] ; [[Khasnabish & Haiven 2015]]; [[Callon 2007]]
- "research on alternative organizing has moved beyond the denaturalization of hierarchy towards the affirmation of non-hierarchical organizational forms." ([[King & Land 2018]] p5)
- "we are required to develop new methodologies if our role, as academics, is to develop and foster positive organizational change, rather than simply critiquing from a distance." ([[King & Land 2018]])
	 - Work “with practitioners and activists to **develop campaigns or new practices** around the dilemmas that practitioners face {…}.   “Academics, working in Business Schools, can provide legitimacy and institutional resources for {such} campaigns.” ([[King 2015]], p. 262)
	 - “work directly in organizational practice to **rethink existing practices** in new, creative and empowering ways” ([[King 2015]], p. 262)
	 - “work as a form of **translator** {…}, taking ideas from one arena (such as social movement theory) and then trying to place them in the context of another (such as the voluntary sector).” [[King 2015]], p. 263)
- Working alongside [[social movements]] as academics studying and prefiguring [[real utopias]], adopting research strategies that are explicitly ‘in solidarity’ with social movements” [[Khasnabish and Haiven 2015]], p. 25)

### Four approaches that may help render CMS more [[critical performativity|critically performative]]

- **Activism within the business school and university**
- **Critical pedagogy**
	- “must inherently remain **non-performative**, indeterminate and marked by the expectation of failure. As Weber (1946) presciently noted, the task of raising political awareness in the classroom cannot simply be an instrumental moment of indoctrination, whereby potentially ‘bad’ future managers are remoulded into ‘good’ future ones. Critical pedagogy instead seeks to engender spaces of intellectual openness and inquiry, demonstrating how certain management practices we take for granted are neither natural nor inevitable.” ([[Fleming & Banerjee 2016]], p. 13)
- **Public Critical Management Studies**
	- “We are surprised that new calls for performativity inordinately privilege managers as agents of change, rather than, say, social and environmental activists, the unemployed and precarious workforce, democratically elected union officials, etc. Rather than ‘lovingly struggle’ (Spicer et al., 2009: 548) with managers and treating them as the exclusive audience of CMS, we suggest that research ought to engage wider public forums.” ([[Fleming & Banerjee 2016]], p. 14)
	- “practitioners are often too enmeshed in the means-ends rationalities of their organizations to be effective change agents in the way new performativity advocates envisage. In many cases, some kind of external catalyst or pressure is required to enact reforms and progressive changes in organizations.” ([[Fleming & Banerjee 2016]], p. 14)
	 - “We suggest that a potentially effective way to enact change in organizations is by developing a ‘[[public CMS]]’. Systematic research and its findings – which will often reveal an injustice and a possible alternative – could be disseminated to raise awareness and reflexive dialogue within the public imagination, policy makers and think tanks to enforce change upon organizations.” ([[Fleming & Banerjee 2016]], p. 14)
- **Theory development**  
	- “if CMS is to make an impact, it needs to be highly committed to what ostensibly appears to be a non-performative activity; namely, a prolonged engagement with abstract, often difficult ideas and phenomenon: study. Without an informed and critical understanding of power, capitalism, gender, environmental issues, post-colonialism and other areas, when called upon to speak (by students, the media, the state, activists, etc.) we will have little ‘useful’ to say.” ([[Fleming & Banerjee 2016]], p. 15)
	- “Indeed, it is fascinating that precisely when we are being told to read airport management books rather than Foucault, economic elites are pouring substantial amounts of funding into think tanks to do just the opposite (but in the favour of the powerful): secluded, abstract and painstaking study of modern society (Medvetz, 2012).” ([[Fleming & Banerjee 2016]], p. 15)
	- “It is imperative that we strive (even if perpetually failing) to gain a complex grasp of what is happening in the global political economy of organizations and what alternatives may be possible. Such knowledge does not come easy. It requires time, reading, revision, critical reflection, non-standard texts, debate; activities that from a technocratic perspective seem ‘useless’ and ‘irrelevant’ to real world managers.” ([[Fleming & Banerjee 2016]], p. 15)
	- “Utopian thinking does not only represent a ‘no place’. It is also an important method (Levitas, 2013) for articulating an unacceptable present and identifying alternatives, even if not fully realizable” ([[Fleming & Banerjee 2016]], p. 17) - [[utopia as method]]

### Examples of [[critical performativity]] in practice

- Critical [[performativity engines]] in Technological Incubators for Popular Cooperatives in Brazil - [[Leca, Gond & Barin Cruz 2014]]
- [[critical performativity]] in the Facultad Abierta extension programme - [[Esper, Cabantous, Barin-Cruz & Gond 2017]]

